# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

bl_info = {
    "name" : "Octane Tools",
    "author" : "Andreas Resch", 
    "description" : "Tools for Octane Renderer (for Blender 4.x)",
    "blender" : (4, 0, 0),
    "version" : (0, 4, 1),
    "location" : "",
    "warning" : "",
    "doc_url": "", 
    "tracker_url": "", 
    "category" : "3D View" 
}

import bpy
from . import ot_main_tools
from . import ot_material_tools

class OCTTOOLS_ADDONPREFERENCES(bpy.types.AddonPreferences):
    bl_idname = __name__
    
    # SHOW RENDER OVERRIDES
    show_render_overrides: bpy.props.BoolProperty(
        name="Show Render Override Checkboxes",
        default=True
    )

    def draw(self, context):
        layout = self.layout
        layout.prop(self, "show_render_overrides")

def register():
    from bpy.utils import register_class  
    bpy.utils.register_class(OCTTOOLS_ADDONPREFERENCES)
    ot_main_tools.main_tools_register()
    ot_material_tools.material_tools_register()


def unregister():
    from bpy.utils import unregister_class
    bpy.utils.unregister_class(OCTTOOLS_ADDONPREFERENCES)
    ot_main_tools.main_tools_unregister()
    ot_material_tools.material_tools_unregister()

if __name__ == "__main__":
    register()
